k6 `v0.55.0` is here 🎉! This release includes:

- ⚠️ The deprecated StatsD output has been removed.
- ⚠️ The experimental `k6/experimental/tracing` module has been removed.
- 🆕 URL grouping support in the browser module.
- 🆕 Top-level `await` support.
- 🔐 Complete RSA support for `k6/experimental/webcrypto`.

## Breaking changes

### `k6/experimental/tracing` module removed [`#3855`](https://github.com/grafana/k6/pull/3855)

The experimental `k6/experimental/tracing` module has been removed, in favor of a replacement [jslib](https://jslib.k6.io/http-instrumentation-tempo/) polyfill, please consult our [guide on how to migrate](https://grafana.com/docs/k6/latest/javascript-api/jslib/http-instrumentation-tempo/#migration-from-k6experimentaltracing), [`#3855`](https://github.com/grafana/k6/pull/3855).

### StatsD output removed [`#3849`](https://github.com/grafana/k6/pull/3849)

The StatsD output was deprecated in k6 v0.47.0 and is now removed. You could still output results to StatsD using the community xk6 extension [LeonAdato/xk6-output-statsd](https://github.com/LeonAdato/xk6-output-statsd). Thanks, @LeonAdato for taking over the extension!

### `open` will have a breaking change in the future.

Currently, `open` opens relative files based on an unusual root, similar to how `require` behaved before it was updated for ESM compatibility. To make k6 more consistent, `open` and other functions like it will start handling relative paths in the same way as imports and `require`.
For a more in-depth explanation, please refer to the related [issue](https://github.com/grafana/k6/issues/3857).

With this version, k6 will start emitting warnings when it detects that in the future, this will break. We recommend using [`import.meta.resolve()`](https://grafana.com/docs/k6/latest/javascript-api/import.meta/resolve/) as a way to make your scripts future proof.

### `http.file#data` now truly has the same type as the provided data [`#4009`](https://github.com/grafana/k6/pull/4009)

Previously `http.file#data` was always a slice of byte (`[]byte`) - which was very likely a bug and a leftover from years past.

The original aim (also documented) was to have the same type as the data provided when creating the `http.file` object, and it is now effectively the case.

## New features

### Top-level await support [`4007`](https://github.com/grafana/k6/pull/4007)

After the initial native support for ECMAScript modules, k6 can now load those modules asynchronously which also allows `await` to be used in the top-level of a module. That is you can write `await someFunc()` directly in the top most level of a module instead of having to make an async function that you call that can than use `await`.

Until now, you had to wrap your code in an async function to use `await` in the top-level of a module. For example, the following code:

```javascript
import { open } from 'k6/experimental/fs'
import csv from 'k6/experimental/csv'

let file;
let parser;
(async function () {
	file = await open('data.csv');
	parser = new csv.Parser(file);
})();
```

Can now be written as:

```javascript
import { open } from 'k6/experimental/fs'
import csv from 'k6/experimental/csv'

const file = await open('data.csv');
const parser = new csv.Parser(file);
```

This should make using the increasing number of async APIs in k6 easier in the [init context](https://grafana.com/docs/k6/latest/using-k6/test-lifecycle/#the-init-stage).

This is not allowed in case of using the CommonJS modules, only ECMAScript modules, as CommonJS modules are synchronous by definition.

### Complete[^1] RSA support for `k6/experimental/webcrypto` [`#4025`](https://github.com/grafana/k6/pull/4025)

This update includes support for the RSA family of algorithms, including `RSA-OAEP`, `RSA-PSS` and `RSASSA-PKCS1-v1_5`. You can use these algorithms with the `crypto.subtle` API in the same way as the other algorithms, precisely for `generateKey`, `importKey`, `exportKey`, `encrypt`, `decrypt`, `sign`, and `verify` operations.

By implementing RSA support, we make our WebCrypto API implementation more complete and useful for a broader range of use cases.

[^1]: Since under the hood we do fully rely on the Golang's SDK, our implementation doesn't support zero salt lengths for the `RSA-PSS` `sign`/`verify` operations.

#### Example usage

<details>
<summary>Expand to see an example of generation RSA-PSS key pair.</summary>

```javascript
import { crypto } from "k6/experimental/webcrypto";

export default async function () {
  const keyPair = await crypto.subtle.generateKey(
    {
      name: "RSA-PSS",
      modulusLength: 2048,
      publicExponent: new Uint8Array([1, 0, 1]),
      hash: { name: "SHA-1" },
    },
    true,
    ["sign", "verify"]
  );

  console.log(JSON.stringify(keyPair));
}
```

</details>

### `page.on('metric)` to group urls [browser#371](https://github.com/grafana/xk6-browser/issues/371), [browser#1487](https://github.com/grafana/xk6-browser/issues/1487)

Modern websites are complex and make a high number of requests to function as intended by their developers. These requests no longer serve only content for display to the end user but also retrieve insights, analytics, advertisements, and for cache-busting purposes. Such requests are usually generated dynamically and may contain frequently changing IDs, posing challenges when correlating and analyzing your k6 test results.

When load testing a website using the k6 browser module, these dynamic requests can result in a high number of similar-looking requests, making it difficult to correlate them and extract valuable insights. This can also lead to test errors, such as a "too-many-metrics" error, due to high cardinality from metrics tagged with similar but dynamically changing URLs.

This issue also affects synthetic tests. While you may not encounter the "too-many-metrics" error, you may end up with a large amount of uncorrelated metric data that cannot be tracked effectively over time.

To address this in the browser module, we have implemented `page.on('metric')`, which allows you to define URL patterns using regex for matching. When a match is found, the URL and name tags for the metric are replaced with the new name.

#### Example usage

<details>
<summary>Expand to see an example of working with `page.on('metric')`.</summary>

```js

import { browser } from 'k6/browser';

export const options = {
  scenarios: {
    ui: {
      executor: 'shared-iterations',
      options: {
        browser: {
            type: 'chromium',
        },
      },
    },
  },
}

export default async function() {
  const page = await browser.newPage();

  // Here, we set up an event listener using page.on('metric').
  // You can call page.on('metric') multiple times, and each callback function
  // will be executed in the order that page.on was called.
  page.on('metric', (metric) => {
    // Currently, metric.tag is the only available method on the metric object.
    // It enables matching on the URL tag using a specified regex pattern.
    // You can call metric.tag multiple times within the callback function.
    metric.tag({
      // This is the new name assigned to any metric that matches the defined
      // URL pattern below.
      name: 'test',
      // Provide one or more match patterns here. Any metrics that match a pattern
      // will use the new name specified above.
      matches: [
        // Each match pattern can include a URL and an optional method.
        // When a method is specified, the metric must match both the URL pattern
        // and the method. If no method is provided, the pattern will match all
        // HTTP methods.
        {url: /^https:\/\/test\.k6\.io\/\?q=[0-9a-z]+$/, method: 'GET'},
      ]
    });
  });

  try {
    // The following lines are for demonstration purposes.
    // Visiting URLs with different query parameters (q) to illustrate matching.
    await page.goto('https://test.k6.io/?q=abc123');
    await page.goto('https://test.k6.io/?q=def456');
  } finally {
    // Ensure the page is closed after testing.
    await page.close();
  }
}

```

</details>

### `ControlOrMeta` support in the keyboard [browser#1457](https://github.com/grafana/xk6-browser/pull/1457)

This approach enables tests to be written for all platforms, accommodating either `Control` or `Meta` for keyboard actions. For example, `Control+click` on Windows and `Meta+click`on Mac to open a link in a new window.

#### Example usage

<details>
<summary>Expand to see an example usage of `ControlOrMeta`</summary>

```js
  await page.keyboard.down('ControlOrMeta');

  // Open the link in a new tab.
  // Wait for the new page to be created.
  const browserContext = browser.context();
  const [newTab] = await Promise.all([
    browserContext.waitForEvent('page'),
    await page.locator('a[href="/my_messages.php"]').click()
  ]);

  await page.keyboard.up('ControlOrMeta');
```

</details>

## UX improvements and enhancements

- [browser#1462](https://github.com/grafana/xk6-browser/pull/1462) Enhances `waitForSelector` error message to better reflect why a selector doesn't resolve to an element.
- [#4028](https://github.com/grafana/k6/pull/4028) Adds support of SigV4 signing for the `experimental-prometheus-rw` output. This allows users to authenticate with AWS services that require SigV4 signing. Thanks, @obanby for the contribution!
- [#4026](https://github.com/grafana/k6/pull/4026) Allows setting of service.name from the `OTEL_SERVICE_NAME` environment variable for the `experimental-opentelemetry` output. This aligns better with standard OTEL practices. Thanks, @TimotejKovacka for the contribution!
- [browser#1426](https://github.com/grafana/xk6-browser/issues/1426) Instruments `page.waitForTimeout` with tracing which will allow it to be displayed in the timeline.

## Bug fixes

- [browser#1452](https://github.com/grafana/xk6-browser/pull/1452) Fixes a possible deadlock when working with `page.on`.
- [browser#1469](https://github.com/grafana/xk6-browser/pull/1469) Fixes `locator.waitFor` so it waits between navigations and doesn't throw an error.
- [browser#1488](https://github.com/grafana/xk6-browser/pull/1488), [browser#1493](https://github.com/grafana/xk6-browser/pull/1493) Fixes memory leaks.
- [#4017](https://github.com/grafana/k6/pull/4017) Fixes a bug where k6 would not stop when a test was aborted right after an `await` statement. 

## Maintenance and internal improvements

- [browser#1448](https://github.com/grafana/xk6-browser/pull/1448) Updates examples to use the new async `check` helper.
- [browser#1473](https://github.com/grafana/xk6-browser/pull/1473), [browser#1474](https://github.com/grafana/xk6-browser/pull/1474), [browser#1477](https://github.com/grafana/xk6-browser/pull/1477), [browser#1478](https://github.com/grafana/xk6-browser/pull/1478), [browser#1475](https://github.com/grafana/xk6-browser/pull/1475), [browser#1479](https://github.com/grafana/xk6-browser/pull/1479) Generalizes `page.on` event code to streamline the addition and running of additional events.
- [browser#1439](https://github.com/grafana/xk6-browser/pull/1439) Updates README to remove outdated information.
- [browser#1496](https://github.com/grafana/xk6-browser/pull/1496) Adds the `downloadsPath` option to specify the download directory. The browser module doesn't yet respect this option, but it will in the next release.
- [browser#1447](https://github.com/grafana/xk6-browser/pull/1447) Updates the CDP dependency.
- [browser#1281](https://github.com/grafana/xk6-browser/issues/1281), [browser#1277](https://github.com/grafana/xk6-browser/issues/1277), [browser#1275](https://github.com/grafana/xk6-browser/issues/1275) Removes Sobek out of business logic layers.
- [#4037](https://github.com/grafana/k6/pull/4037), [#4043](https://github.com/grafana/k6/pull/4043) Updates recommendation to use `check` polyfill, for the async checks.
- [#4039](https://github.com/grafana/k6/pull/4039) Updates maintainers in auto-assigner workflow.
